//
//  BPURLDictionaryMessage.h
//  BISubstrate
//
//  Created by Alykhan Jetha on 10-06-01.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import "BPURLMessage.h"


@interface BPURLDictionaryMessage : BPURLMessage {
	NSMutableData *bytes;
	NSDictionary *requestDictionary;
	NSDictionary *responseDictionary;
	
	NSUInteger bytesReceived;
	NSUInteger expectedBytes;
	
}

@property (retain) NSMutableData *bytes;
@property (retain) NSDictionary *requestDictionary;
@property (retain) NSDictionary *responseDictionary;

@property (assign) NSUInteger expectedBytes;
@property (assign) NSUInteger bytesReceived;

/*!
 Designated initializer. Make sure you use the encoded username and password, otherwise names and password with unicode in them will not work.
 */
- (id)initForURL:(NSString *)aURLStr
		 request:(NSDictionary *)requestDict
		username:(NSString *)aUsername 
		password:(NSString *)aPassword
		delegate:(id)aDeleg;

@end

@interface NSObject (BPURLDictionaryMessageDelegate)
- (void)dictionaryMessage:(BPURLDictionaryMessage *)message failedWithError:(NSError *)anError;
- (void)dictionaryMessageDidFinish:(BPURLDictionaryMessage *)message;
@end